from django import forms
from django.contrib.auth.forms import AuthenticationForm
from django.contrib.auth import get_user_model

User = get_user_model()

class LoginForm(AuthenticationForm):
    username = forms.CharField(label="Email or Username", widget=forms.TextInput(attrs={"class":"form-control", "placeholder":"Email or Username"}))
    password = forms.CharField(label="Password", widget=forms.PasswordInput(attrs={"class":"form-control", "placeholder":"Password"}))

class RegisterForm(forms.ModelForm):
    password1 = forms.CharField(label="Password", widget=forms.PasswordInput(attrs={"class":"form-control", "placeholder":"Create password"}))
    password2 = forms.CharField(label="Confirm Password", widget=forms.PasswordInput(attrs={"class":"form-control", "placeholder":"Confirm password"}))

    class Meta:
        model = User
        fields = ["first_name", "last_name", "username", "email", "role"]
        widgets = {
            "first_name": forms.TextInput(attrs={"class":"form-control", "placeholder":"First name"}),
            "last_name": forms.TextInput(attrs={"class":"form-control", "placeholder":"Last name"}),
            "username": forms.TextInput(attrs={"class":"form-control", "placeholder":"Username"}),
            "email": forms.EmailInput(attrs={"class":"form-control", "placeholder":"Email"}),
            "role": forms.Select(attrs={"class":"form-select"}),
        }

    def clean(self):
        cleaned = super().clean()
        p1 = cleaned.get("password1")
        p2 = cleaned.get("password2")
        if p1 and p2 and p1 != p2:
            self.add_error("password2", "Passwords do not match.")
        return cleaned

    def save(self, commit=True):
        user = super().save(commit=False)
        user.set_password(self.cleaned_data["password1"])
        if commit:
            user.save()
        return user
