from django.contrib.auth import login, authenticate
from django.contrib.auth.views import LoginView, LogoutView
from django.shortcuts import redirect, render
from django.urls import reverse_lazy
from .forms import LoginForm, RegisterForm

class UserLoginView(LoginView):
    template_name = "auth/login.html"
    authentication_form = LoginForm

    def get_success_url(self):
        return reverse_lazy("portal:router")

class UserLogoutView(LogoutView):
    next_page = reverse_lazy("pages:home")

def register_view(request):
    if request.user.is_authenticated:
        return redirect("portal:router")
    if request.method == "POST":
        form = RegisterForm(request.POST)
        if form.is_valid():
            user = form.save()
            raw_password = form.cleaned_data.get("password1")
            # Authenticate to attach the correct backend when multiple AUTHENTICATION_BACKENDS are configured
            authed = authenticate(request, username=user.username, password=raw_password) or authenticate(request, username=user.email, password=raw_password)
            if authed is not None:
                login(request, authed)
            else:
                # Fallback (should rarely happen) - use default ModelBackend
                login(request, user, backend="django.contrib.auth.backends.ModelBackend")
            return redirect("portal:router")
    else:
        form = RegisterForm()
    return render(request, "auth/register.html", {"form": form})
