from django.db import migrations, models

class Migration(migrations.Migration):

    dependencies = [
        ("bookings", "0001_initial"),
    ]

    operations = [
        migrations.AddField(
            model_name="booking",
            name="tutor_response_note",
            field=models.CharField(blank=True, max_length=255),
        ),
        migrations.AddField(
            model_name="booking",
            name="tutor_responded_at",
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name="booking",
            name="status",
            field=models.CharField(
                choices=[
                    ("new", "New"),
                    ("assigned", "Assigned"),
                    ("tutor_accepted", "Tutor Accepted"),
                    ("tutor_declined", "Tutor Declined"),
                    ("confirmed", "Confirmed"),
                    ("completed", "Completed"),
                    ("cancelled", "Cancelled"),
                ],
                default="new",
                max_length=20,
            ),
        ),
    ]
