from rest_framework import serializers
from .models import Conversation, Message

class MessageSerializer(serializers.ModelSerializer):
    sender_name = serializers.SerializerMethodField()

    class Meta:
        model = Message
        fields = ["id","conversation","sender","sender_name","text","created_at","is_read"]
        read_only_fields = ["id","conversation","sender","created_at","is_read","sender_name"]

    def get_sender_name(self, obj):
        u = obj.sender
        return u.get_full_name() or u.username or u.email

class ConversationSerializer(serializers.ModelSerializer):
    last_message = serializers.SerializerMethodField()

    class Meta:
        model = Conversation
        fields = ["id","booking","student","tutor","created_at","last_message"]
        read_only_fields = fields

    def get_last_message(self, obj):
        m = obj.messages.order_by("-created_at").first()
        return {"text": m.text[:120], "created_at": m.created_at} if m else None
