from django.contrib import admin
from .models import ConsultationRequest

@admin.register(ConsultationRequest)
class ConsultationRequestAdmin(admin.ModelAdmin):
    list_display = ("created_at", "source", "name", "email", "phone", "country", "subject", "is_processed")
    list_filter = ("source", "is_processed", "created_at")
    search_fields = ("name", "email", "phone", "country", "subject", "message")
    readonly_fields = ("created_at",)
