/*
  Booking flow (frontend-only):
  Step1: choose service/exam + level + timezone
  Step2: choose subject + goal
  Step3: choose schedule + preferred platform
  Confirm: summary
*/
const KEY = "enabled_booking_draft_v1";

function getCookie(name) {
  const value = `; ${document.cookie}`;
  const parts = value.split(`; ${name}=`);
  if (parts.length === 2) return parts.pop().split(';').shift();
  return "";
}

function saveDraft(obj){
  localStorage.setItem(KEY, JSON.stringify(obj));
}
function loadDraft(){
  try { return JSON.parse(localStorage.getItem(KEY) || "{}"); } catch { return {}; }
}
function clearDraft(){
  localStorage.removeItem(KEY);
}

function $(id){ return document.getElementById(id); }

function initStep1(){
  const d = loadDraft();
  if ($("bfService")) $("bfService").value = d.service || "";
  if ($("bfType")) $("bfType").value = d.type || "Service";
  if ($("bfLevel")) $("bfLevel").value = d.level || "Secondary";
  if ($("bfTz")) $("bfTz").value = d.timezone || "Africa/Lagos";

  const form = $("bookingStep1");
  const msg = $("bfMsg");
  if (!form) return;

  form.addEventListener("submit", (e) => {
    e.preventDefault();
    const draft = {
      ...d,
      type: $("bfType").value,
      service: $("bfService").value,
      level: $("bfLevel").value,
      timezone: $("bfTz").value
    };
    if (!draft.service){
      if (msg) msg.textContent = "Please select a service/exam.";
      return;
    }
    saveDraft(draft);
    location.href = "/portal/student/booking-step2/";
  });
}

function initStep2(){
  const d = loadDraft();
  if ($("bfSubject")) $("bfSubject").value = d.subject || "";
  if ($("bfGoal")) $("bfGoal").value = d.goal || "";
  const meta = $("bfMeta");
  if (meta) meta.textContent = `${d.type || "Service"} • ${d.service || ""} • ${d.level || ""}`;

  const form = $("bookingStep2");
  const msg = $("bfMsg2");
  if (!form) return;

  $("bfBack2")?.addEventListener("click", () => history.back());

  form.addEventListener("submit", (e) => {
    e.preventDefault();
    const draft = {
      ...d,
      subject: $("bfSubject").value.trim(),
      goal: $("bfGoal").value.trim()
    };
    if (!draft.subject){
      if (msg) msg.textContent = "Please enter a subject (e.g., Maths, English, Python).";
      return;
    }
    saveDraft(draft);
    location.href = "/portal/student/booking-step3/";
  });
}

function initStep3(){
  const d = loadDraft();
  const meta = $("bfMeta3");
  if (meta) meta.textContent = `${d.service || ""} • ${d.subject || ""}`;

  if ($("bfPlatform")) $("bfPlatform").value = d.platform || "Google Meet";
  if ($("bfDays")) $("bfDays").value = d.days || "Mon, Wed, Fri";
  if ($("bfTime")) $("bfTime").value = d.time || "4:00 PM";
  if ($("bfFreq")) $("bfFreq").value = d.frequency || "2 sessions/week";

  $("bfBack3")?.addEventListener("click", () => history.back());

  const form = $("bookingStep3");
  const msg = $("bfMsg3");
  if (!form) return;

  form.addEventListener("submit", (e) => {
    e.preventDefault();
    const draft = {
      ...d,
      platform: $("bfPlatform").value,
      days: $("bfDays").value.trim(),
      time: $("bfTime").value.trim(),
      frequency: $("bfFreq").value
    };
    if (!draft.days || !draft.time){
      if (msg) msg.textContent = "Please fill preferred days and time.";
      return;
    }
    saveDraft(draft);
    location.href = "/portal/student/booking-confirm/";
  });
}

function initConfirm(){
  const d = loadDraft();
  const box = $("bfSummary");
  if (!box) return;

  const rows = [
    ["Type", d.type || ""],
    ["Service/Exam", d.service || ""],
    ["Level", d.level || ""],
    ["Subject", d.subject || ""],
    ["Goal", d.goal || ""],
    ["Platform", d.platform || ""],
    ["Preferred Days", d.days || ""],
    ["Preferred Time", d.time || ""],
    ["Frequency", d.frequency || ""],
    ["Timezone", d.timezone || ""]
  ];

  box.innerHTML = rows.map(([k,v]) => `
    <div class="d-flex justify-content-between gap-3 py-2 border-bottom">
      <div class="fw-semibold">${k}</div>
      <div class="text-muted text-end">${(v || "—")}</div>
    </div>
  `).join("");

  $("bfBack4")?.addEventListener("click", () => history.back());

    $("bfSubmit")?.addEventListener("click", async () => {
    const msg = $("bfDone");
    if (msg) msg.textContent = "Submitting…";

    // Map draft -> API payload
    const payload = {
      service: (d.type === "Exam Prep" ? "Exam Preparation Support" : (d.service || d.type || "Tutoring")),
      subject: d.subject || "",
      exam: d.type === "Exam Prep" ? (d.service || "") : "",
      level: d.level || "",
      description: d.goal ? `Goal: ${d.goal}
Platform: ${d.platform || ""}
Frequency: ${d.frequency || ""}` : "",
      preferred_date: null,
      preferred_time: d.time || "",
      timezone: d.timezone || ""
    };

    try{
      const res = await fetch("/api/bookings/", {
        method: "POST",
        headers: {
          "Content-Type": "application/json",
          "X-CSRFToken": getCookie("csrftoken")
        },
        credentials: "same-origin",
        body: JSON.stringify(payload)
      });

      if (!res.ok){
        const t = await res.text();
        if (msg) msg.textContent = "❌ Could not submit. Please try again.";
        console.error("Booking submit failed:", t);
        return;
      }

      clearDraft();
      if (msg) msg.textContent = "✅ Booking request submitted!";
      setTimeout(() => location.href = "/portal/student/bookings/", 900);

    }catch(err){
      console.error(err);
      if (msg) msg.textContent = "❌ Network error. Please try again.";
    }
  });
}


// Auto-init based on body attribute
document.addEventListener("DOMContentLoaded", () => {
  const step = document.body.getAttribute("data-booking-step");
  if (step === "1") initStep1();
  if (step === "2") initStep2();
  if (step === "3") initStep3();
  if (step === "4") initConfirm();
});
