const CACHE_NAME = "enabled-tutors-v1";

const ASSETS = [
  "/",
  "/index.html",
  "/offline.html",
  "/manifest.json",

  "/components/header.html",
  "/components/footer.html",
  "/components/page-header.html",

  "/css/main.css",

  "/js/include.js",
  "/js/main.js",
  "/js/install.js",
  "/js/booking.js",
  "/js/sw.js",

  "/pages/about.html",
  "/pages/services.html",
  "/pages/exams.html",
  "/pages/exam-waec.html",
  "/pages/exam-gcse.html",
  "/pages/exam-sat.html",
  "/pages/exam-11plus.html",
  "/pages/pricing.html",
  "/pages/contact.html",

  "/auth/login.html",
  "/auth/register.html",

  "/portal/student/index.html",
  "/portal/student/bookings.html",
  "/portal/student/assignments.html",
  "/portal/student/profile.html",
  "/portal/student/new-booking.html",
  "/portal/student/booking-step2.html",
  "/portal/student/booking-step3.html",
  "/portal/student/booking-confirm.html",

  "/portal/tutor/index.html",
  "/portal/tutor/bookings.html",
  "/portal/tutor/students.html",
  "/portal/tutor/earnings.html",
  "/portal/tutor/profile.html",

  "/assets/img/logo.jpg",
  "/assets/icons/icon-192.png",
  "/assets/icons/icon-512.png",
  "/assets/icons/maskable-192.png",
  "/assets/icons/maskable-512.png"
];

self.addEventListener("install", (event) => {
  event.waitUntil(caches.open(CACHE_NAME).then((c) => c.addAll(ASSETS)));
  self.skipWaiting();
});

self.addEventListener("activate", (event) => {
  event.waitUntil(
    caches.keys().then(keys => Promise.all(keys.map(k => (k !== CACHE_NAME ? caches.delete(k) : null))))
  );
  self.clients.claim();
});

self.addEventListener("fetch", (event) => {
  const req = event.request;
  event.respondWith(
    caches.match(req).then((cached) => cached || fetch(req).catch(() => caches.match("/offline.html")))
  );
});
