from django.contrib import admin
from .models import Conversation, Message, SupportThread, SupportMessage


@admin.register(Conversation)
class ConversationAdmin(admin.ModelAdmin):
    list_display = ("id", "booking", "student", "tutor", "created_at")
    search_fields = ("id", "booking__id", "student__username", "tutor__username")
    list_filter = ("created_at",)


@admin.register(Message)
class MessageAdmin(admin.ModelAdmin):
    list_display = ("id", "conversation", "sender", "created_at", "is_read")
    search_fields = ("text", "sender__username")
    list_filter = ("created_at", "is_read")


@admin.register(SupportThread)
class SupportThreadAdmin(admin.ModelAdmin):
    list_display = ("id", "user", "session_key", "assigned_staff", "status", "updated_at")
    search_fields = ("id", "user__username", "session_key", "assigned_staff__username")
    list_filter = ("status", "updated_at")


@admin.register(SupportMessage)
class SupportMessageAdmin(admin.ModelAdmin):
    list_display = ("id", "thread", "sender_label", "sender", "created_at", "is_read")
    search_fields = ("text", "sender__username")
    list_filter = ("sender_label", "created_at", "is_read")
