from django.db import models

class ConsultationRequest(models.Model):
    SOURCE_CHOICES = (
        ("consultation", "Consultation Form"),
        ("lead", "Lead Form"),
    )

    source = models.CharField(max_length=32, choices=SOURCE_CHOICES, default="consultation")
    name = models.CharField(max_length=120)
    email = models.EmailField()
    phone = models.CharField(max_length=40, blank=True)
    country = models.CharField(max_length=80, blank=True)
    subject = models.CharField(max_length=160, blank=True)
    message = models.TextField(blank=True)
    page_url = models.URLField(blank=True)

    created_at = models.DateTimeField(auto_now_add=True)
    is_processed = models.BooleanField(default=False)

    class Meta:
        ordering = ["-created_at"]

    def __str__(self):
        return f"{self.name} ({self.email})"
