from django.urls import path
from . import views

app_name = "pages"

urlpatterns = [
    path('components/<str:name>.html', views.component_partial, name='component_partial'),
    path("", views.home, name="home"),
    path("services/", views.services, name="services"),
    path("exams/", views.exams, name="exams"),
    path("exams/<slug:slug>/", views.exam_detail, name="exam_detail"),
    path("pricing/", views.pricing, name="pricing"),
    path("about/", views.about, name="about"),
    path("contact/", views.contact, name="contact"),
path("api/consultation/", views.consultation_submit, name="consultation_submit"),
path("api/lead/", views.lead_submit, name="lead_submit"),
]
