from django.urls import path
from . import views

app_name = "portal"

urlpatterns = [
    
    path('staff/support/', views.staff_support_inbox, name='staff_support_inbox'),
    path('staff/support/<int:thread_id>/', views.staff_support_thread, name='staff_support_thread'),
path("", views.router, name="router"),
    path("student/", views.student_dashboard, name="student_dashboard"),
    path("student/bookings/", views.bookings_list, name="student_bookings"),
    path("student/new-booking/", views.new_booking, name="new_booking"),
    path("student/booking-step2/", views.booking_step2, name="booking_step2"),
    path("student/booking-step3/", views.booking_step3, name="booking_step3"),
    path("student/booking-confirm/", views.booking_confirm, name="booking_confirm"),

    path("tutor/", views.tutor_dashboard, name="tutor_dashboard"),

    path("student/chats/", views.student_chats, name="student_chats"),
    path("student/chats/<int:booking_id>/", views.student_chat_room, name="student_chat_room"),

    path("tutor/chats/", views.tutor_chats, name="tutor_chats"),
    path("tutor/chats/<int:booking_id>/", views.tutor_chat_room, name="tutor_chat_room"),

]
